#include <stdio.h>
#include "patchlevel.h"
#include "url.h"
#include "HTAccess.h"
#include "HText.h"
#include "HTParse.h"
#include "HTFWriter.h"
#include "HTFormat.h"
#include "HTTP.h"
#include "HTAlert.h"

/* Given absolute URL, open a temporary filename, and do the transfer */

#define LINE 512
char buf[LINE];

PUBLIC char *HTAppName = "XHdvi"; /* Application name */
PUBLIC char *HTAppVersion = PATCHLEVEL; /* Application version */

/* Following need to be defined for the WWW library, but are not used */
struct _HText {
	FILE *strm;
};

struct _HTStream {                      /* only know it as object */
    CONST HTStreamClass *       isa;
    /* ... */
};

BOOL HText_selectAnchor(text, anchor)
HText *text;
HTChildAnchor *anchor;
{
	fprintf(stderr, "HText_selectAnchor called\n");
}

BOOL HText_select(text)
HText *text;
{
	fprintf(stderr, "HText_select called\n");
}

HText *HText_new2(anchor,output_stream)
HTParentAnchor *anchor;
HTStream *output_stream;
{
	fprintf(stderr, "HText_new2 called\n");
}

void HText_beginAppend (text)
HText *text;
{
	fprintf(stderr, "HText_beginAppend called\n");
}

void HText_setStyle(text, style)
HText *text;
HTStyle *style;
{
	fprintf(stderr, "HText_setStyle called\n");
}

void HText_appendCharacter(text, ch)
HText *text;
char ch;
{
	fprintf(stderr, "HText_appendCharacter called\n");
}

void HText_appendParagraph(text)
HText *text;
{
	fprintf(stderr, "HText_appendParagraph called\n");
}

void HText_appendText(text, str)
HText *text;
CONST char *str;
{
	fprintf(stderr, "HText_appendText called\n");
}

void HText_appendImage(text, anc, alternative_text, alignment, isMap)
HText *text;
HTChildAnchor *anc;
CONST char * alternative_text;
CONST char * alignment;
BOOL isMap;
{
	fprintf(stderr, "HText_appendImage called\n");
}

void HText_beginAnchor(text, anc)
HText *text;
HTChildAnchor *anc;
{
	fprintf(stderr, "HText_beginAnchor called\n");
}

void HText_endAnchor(text)
HText *text;
{
	fprintf(stderr, "HText_endAnchor called\n");
}

void HText_endAppend(text)
HText *text;
{
	fprintf(stderr, "HText_endAppend called\n");
}

HTStyleSheet *styleSheet = NULL;
HText *HTMainText = NULL;
HTParentAnchor *HTMainAnchor = NULL;

/* Given absolute URL, open a temporary filename, and do the transfer */

www_fetch(url, savefile)
char *url;
char *savefile;
{
	int resp;
	HTRequest *reqptr;
	FILE *fp;

	if ((fp = fopen(savefile, "w")) == NULL) {
		fprintf(stderr, "Cannot open %s for writing\n", savefile);
		exit(0); /* No cleanup! */
	}
	reqptr = HTRequest_new(); /* A blank request with defaults set */
	HTEnableFrom = YES; /* Says who we are - e-mail address */
	reqptr->output_format = WWW_SOURCE; /* Write out as it came? */
/* Might want HTSaveAndCallBack? */
	reqptr->output_stream = HTFWriter_new(fp, NO);
	HTFormatInitNIM(reqptr->conversions); /* Not sure what this does... */
	HTInteractive = NO;
	resp = HTLoadAbsolute(url, reqptr);
/* We're going to have to figure out what's in the file somehow... */
/*	printf("Content-type: %s\n", (reqptr->content_encoding)->name); */
#ifdef DOFORKS
	exit(1); /* No cleanup! */
#else
	return resp;
#endif
}

/* Turn a relative URL into an absolute one: */
make_absolute(rel, base, len)
char *rel, *base;
int len;
{
        char *cp, *parsed;

	if (base == NULL) return;
        cp = index(rel, '\n');
        if (cp) *cp = '\0'; /* Eliminate newline char */

        parsed = HTParse(rel, base, PARSE_ALL);
        strncpy(rel, parsed, len);
        free(parsed);
}

typedef struct {
	char *url;
	char *savefile;
	pid_t childnum;
} Fetch_Children;

#define MAXC 10 /* Don't send off more than 10 simultaneously */
Fetch_Children fetch_children[MAXC];
static int nchildren = MAXC+1;

/* Start a fetch of a relative URL */
fetch_relative_url(base_url, rel_url, tmpdir)
char *base_url;
char *rel_url;
char *tmpdir;
{
	int i, resp;
	char *savefile;
	char *cp;

	/* Step 1: make the relative URL absolute: */
        strncpy(buf, rel_url, LINE); /* Put it in buf */
	make_absolute(buf, base_url, LINE);

	/* Step 1.5: Check whether we already have it - if so return */
	for (i=0; i < nURLs; i++) {
		if (!strcmp(buf, filelist[i].url)) return(i);
	}
	
	/* Step 2: Find a temporary file to store the output in */
	make_tmp_filename(tmpdir, buf, &savefile);
	if (savefile == NULL) {
		fprintf(stderr, "Could not find temporary file for %s in %s\n",
			buf, tmpdir);
		return(-1);
	}

	/* Step 3: Fork to fetch the URL */
	if (nchildren >= MAXC) wait_for_urls(); /* Wait for the old ones */
	cp = NULL;
	fetch_children[nchildren].url = MyStrAllocCopy(&cp, buf);
	cp = NULL;
	fetch_children[nchildren].savefile = MyStrAllocCopy(&cp, savefile);

	/* Step 4: Update the URL-filename list */
	if (nURLs == 0) {
		filelist = (FiletoURLconv *) xmalloc(FILELISTCHUNK*sizeof(FiletoURLconv), "filelist");
		bzero(filelist,  FILELISTCHUNK*sizeof(FiletoURLconv));
	} else if (nURLs%FILELISTCHUNK == 0) {
		filelist = (FiletoURLconv *) realloc(filelist, (nURLs+FILELISTCHUNK)*sizeof(FiletoURLconv));
		bzero(filelist + nURLs, FILELISTCHUNK*sizeof(FiletoURLconv));
	}
	MyStrAllocCopy(&(filelist[nURLs].url), buf);
	MyStrAllocCopy(&(filelist[nURLs].file), savefile);
	nURLs++;
#ifdef DOFORKS
	fetch_children[nchildren].childnum = fork();
	if (fetch_children[nchildren].childnum == 0) {  /* Child process */
		www_fetch(buf, savefile); /* Get the URL! */
		exit(0); /* Make sure this process quits... */ 
	}
	nchildren++;
#else
	resp = www_fetch(buf, savefile); /* Get the URL! */
	if (resp == 0) {
		paint_anchor("Error: Can't locate URL!\n");
		nURLs--;
		unlink(filelist[nURLs].file); /* Get rid of that temp file */
		return(-1);
	} else {
		nchildren++;
	}
#endif
	return(nURLs-1);
}

wait_for_urls() /* Wait for all the children to finish... */
{
	int status, i, j;
	pid_t ret;

	if (nchildren > MAXC) {
		/* Initialization needed: */
		for (i=0; i < MAXC; i++) {
			fetch_children[i].url = NULL;
			fetch_children[i].savefile = NULL;
		}
	} else {
		for (i=0; i < nchildren; i++) {
#ifdef DOFORKS
			ret = wait(&status); /* Wait for one to finish */
			for (j=0; j < nchildren; j++) {
				if (ret == fetch_children[j].childnum) {
					/* testing: */
					printf("URL %s in file %s: status %d\n",
						fetch_children[j].url,
						fetch_children[j].savefile,
						status);
					break;
				}
			}
#else
			printf("URL %s in file %s\n",
				fetch_children[i].url,
				fetch_children[i].savefile);
#endif
		}
	}
	nchildren = 0;
}

/* Create a temporary directory where we can write files from this program */
make_temporary_dir(tmpdir)
char **tmpdir;
{
	int ret, idval;

	*tmpdir = (char *) malloc(1024*sizeof(char));
	idval = getpid();
	sprintf(*tmpdir, "/usr/tmp/Hd%d", idval);
	ret = mkdir(*tmpdir, 0700);
	if (ret != 0) { /* Didn't work, try local dir */
		sprintf(*tmpdir, "tmpHd%d", idval);
		ret = mkdir(*tmpdir, 0700);
		if (ret < 0) {
			fprintf(stderr, "Couldn't make temporary directory: %s\n",
				*tmpdir);
			exit(1); /* Don't need to clean up!? */
		}
		close(ret); /* Close the directory we just opened? */
	}
}

/* buf is a URL - savefile is local file name to save the file in */
make_tmp_filename(tmpdir, buf, savefile)
char *tmpdir, *buf, **savefile;
{
	char *cp, *cp2;
	int i, j, fd;

	*savefile = NULL;
	cp = rindex(buf, '/');
	if (cp == NULL) cp = rindex(buf, ':');
	if (cp == NULL) return; /* Unsuccessful... */
	if (strlen(cp) < 3) cp = "/tmpfile";
	cp++;
	*savefile = (char *) malloc((strlen(cp) + strlen(tmpdir)+3)*sizeof(char));
	cp2 = rindex(cp, '.'); /* file extension */
	if (cp2 != NULL) {
		*cp2 = '\0';
		cp2++;
		for (i=0; i < 26; i++) { /* Attempt to create new file */
			sprintf(*savefile,"%s/%s%c.%s", tmpdir,cp,'a'+i,cp2);
			for (j=0; j < nURLs; j++) {
				if (!strcmp(*savefile, filelist[j].file)) break;
			}
			if (j < nURLs) continue;
			if ((fd = creat(*savefile,0600)) >= 0) {
				close(fd);
				break;
			}
		}
		cp2--;
		*cp2 = '.'; /* Undo the damage we just did to buf... */
	} else {
		for (i=0; i < 26; i++) { /* Attempt to create new file */
			sprintf(*savefile,"%s/%s%c", tmpdir,cp,'a'+i);
			for (j=0; j < nURLs; j++) {
				if (!strcmp(*savefile, filelist[j].file)) break;
			}
			if (j < nURLs) continue;
			if ((fd = creat(*savefile,0600)) >= 0) {
				close(fd);
				break;
			}
		}
	}
	if (i == 26) { /* Unsuccessful */
		free(*savefile);
		*savefile = NULL;
	}
}
