/*
 * Modifications to DVI previewer for X to do selections.
 * This portion of xhdvi is completely in the public domain. The
 * author renounces any copyright claims. It may be freely used for
 * commercial or non-commercial purposes. The author makes no claims
 * or guarantees - use this at your own risk.
 * 
 * Arthur Smith, U. of Washington, 1994
 * Copyright (c) 1994.  All rights reserved.
 *
 * 9/1994       code written from scratch.
 */

static int sel_first_box;
static int select_start_x;
static int select_start_y;
static int select_end_x;
static int select_end_y;

static char selTranslations[] =
	"Shift<Btn1Down>: StartHighlight()   \n\
	Shift<Btn1Motion>: ExtendHighlight()   \n\
	Shift<Btn1Up>: MakeSelection()";

static XtActionsRec selactions[] = {
	{"StartHighlight", StartHighlight},
	{"ExtendHighlight", ExtendHighlight},
	{"MakeSelection", MakeSelection},
};

static void
StartHighlight(w, event)
drawWidgetClass w;
XButtonEvent *event;
{
	int pos_x, pos_y;

	if (pointerlocate(&pos_x, &pos_y)) {
		sel_first_box = FALSE;
		select_start_x = (pos_x + mane.base_x)*(ht_shrinkfactor << 16);
		select_start_y = (pos_y + mane.base_y)*(ht_shrinkfactor << 16);
		/* Need to clear old selection */
	}
}

static void
ExtendHighlight(w, event)
drawWidgetClass w;
XMotionEvent *event;
{
	static int last_drawn_x, last_drawn_y;
	int event_cell_x, event_cell_y;

	if (pointerlocate(&pos_x, &pos_y)) {
		event_cell_x = (pos_x + mane.base_x)*(ht_shrinkfactor << 16);
		event_cell_y = (pos_y + mane.base_y)*(ht_shrinkfactor << 16);
		if ((event_cell_x == last_drawn_x) && (event_cell_y ==
			last_drawn_y)) return;
		if (sel_first_box) {
			draw_box(w, last_drawn_x, last_drawn_y); /* undraw! */
			draw_box(w, event_cell_x, event_cell_y);
		} else {
			draw(box(w, event_cell_x, event_cell_y);
			sel_first_box = TRUE;
		}
		last_drawn_x = event_cell_x;
		last_drawn_y = event_cell_y;
	}
}

static void
MakeSelection(w, event)
drawWidgetClass w;
XButtonEvent *event;
{
	int temp;

	if (pointerlocate(&pos_x, &pos_y)) {
		select_end_x = (pos_x + mane.base_x)*(ht_shrinkfactor << 16);
		select_end_y = (pos_y + mane.base_y)*(ht_shrinkfactor << 16);
	}
	if ((select_end_x == select_start_x) && (select_end_y ==
			select_start_y)) {
		/* Clear selection? */
		return; /* No selection */
	}
	/* Swap start and end if necessary */
	if (select_end_x < select_start_x) {
		temp = select_end_x;
		select_end_x = select_start_x;
		select_start_x = temp;
	}
	if (select_end_y < select_start_y) {
		temp = select_end_y;
		select_end_y = select_start_y;
		select_start_y = temp;
	}
	if (XtOwnSelection(w, XA_PRIMARY, event->time, convert_proc,
		lose_ownership_proc, transfer_done_proc) == FALSE) {
		XtWarning("%s: failed to become selection owner\n");
		/* Clear selection */
	}
}

static void
draw_box(w, x, y)
drawWidgetClass w;
int x, y;
{
}
