/**
 * The Constants interface is simply a trick that allows us to define
 * certain global constants in a single file.  Classes that need
 * access to these values should be declared with "implements
 * Constants" in their class declaration lines.
 */
public interface Constants {
  
  //
  //  The AXIS_ values give the possible axes for elementary
  //  reflections and glide reflections.
  //
  static final int AXIS_NONE     = 1;	//	no symmetry of the given type
  static final int AXIS_X0       = 2;   //      x ==  0   
  static final int AXIS_X4       = 3;	//      x == 1/4  
  static final int AXIS_Y0	 = 4;	//      y ==  0   
  static final int AXIS_Y4 	 = 5;	//      y == 1/4  

  static final int GROUPTYPE_WALLPAPER	= 0;
  static final int GROUPTYPE_FRIEZE	= 1;
  static final int GROUPTYPE_ROSETTE	= 2;

  //	The GROUP_ values define names for the wallpaper groups
  //	using Conway's notation.
  //
  //		'o' stands for "wallpaper",
  //		'f' stands for "frieze", and
  //		'r' stands for "rosette".
  //
  //	I've had to deviate from Conway's notation to express
  //	everything using only letters and numbers.
  //
  //		Conway's	this
  //		notation	enum
  //
  //		   		 t  ("torus")
  //		   o		 o
  //		   *		 x
  //		   		 i  ("infinity")
  //
  // IMPORTANT NOTE: parts of the Kali source code make use of the
  //   fact that the values of these GROUP_* constants are consectuve
  //   integers starting with 0; in particular, these values are used
  //   as indices into arrays of objects corresponding to the groups.
  //
  //
  //	wallpaper groups
  //
  static final int GROUP_w2222	= 0;
  static final int GROUP_w333	= 1;
  static final int GROUP_w442	= 2;
  static final int GROUP_w632	= 3;
  static final int GROUP_wx2222	= 4;
  static final int GROUP_wx333	= 5;
  static final int GROUP_wx442	= 6;
  static final int GROUP_wx632	= 7;
  static final int GROUP_w4x2	= 8;
  static final int GROUP_w3x3	= 9;
  static final int GROUP_w2x22	= 10;
  static final int GROUP_w22x	= 11;
  static final int GROUP_wxx	= 12;
  static final int GROUP_wxo	= 13;
  static final int GROUP_woo	= 14;
  static final int GROUP_w22o	= 15;
  static final int GROUP_wt	= 16;

  //
  //	frieze groups
  //
  static final int GROUP_fii	= 17;
  static final int GROUP_fix	= 18;
  static final int GROUP_fxii	= 19;
  static final int GROUP_f22i	= 20;
  static final int GROUP_fx22i	= 21;
  static final int GROUP_f2xi	= 22;
  static final int GROUP_fio	= 23;

  //
  //	rosette groups
  //
  static final int GROUP_r1	= 24;
  static final int GROUP_r2	= 25;
  static final int GROUP_r3	= 26;
  static final int GROUP_r4	= 27;
  static final int GROUP_r5	= 28;
  static final int GROUP_r6	= 29;
  static final int GROUP_rx1	= 30;
  static final int GROUP_rx2	= 31;
  static final int GROUP_rx3	= 32;
  static final int GROUP_rx4	= 33;
  static final int GROUP_rx5	= 34;
  static final int GROUP_rx6	= 35;

  //
  // Some math constants
  //
  static final double ROOT2		= 1.41421356237309504880;
  static final double ROOT3		= 1.73205080756887729352;
  static final double COS2PIOVER5	= 0.30901699437494742410;
  static final double SIN2PIOVER5	= 0.95105651629515357211;

  static final double MIN_TRANSLATION	= 10.0;
  static final double MIN_AREA		= 100.0;
  static final double MIN_ALTITUDE	= 5.0;
  
}
