import java.awt.*;

/**
 * The ImageButtonGroup object allows a collection of ImageButtons to
 * function as a radio group.  The ImageButtonGroup object is
 * essentially the same as the java.awt.ButtonGroup object, but works
 * with ImageButtons instead of java.awt.Button objects.
 */
public class ImageButtonGroup {
    /**
     * The current choice.
     */
    ImageButton currentChoice = null;

    /**
     * Creates a new ImageButtonGroup.
     */
    public ImageButtonGroup() {
    }

    /**
     * Gets the current choice.
     */
    public ImageButton getCurrent() {
	return currentChoice;
    }

    /**
     * Sets the current choice to the specified ImageButton.
     * If the ImageButton belongs to a different group, just return.
     * @param button the current ImageButton choice
     */
    public synchronized void setCurrent(ImageButton button) {
	if (button != null && button.group != this) {
	    return;
	}
	ImageButton oldChoice = this.currentChoice;
	this.currentChoice = button;
	if ((oldChoice != null) && (oldChoice != button)) {
	    oldChoice.setState(false);
	}
	if (button != null && oldChoice != button && !button.getState()) {
	    button.setStateInternal(true);
	}
    }

    /**
     * Returns the String representation of this ImageButtonGroup's values.
     * Convert to String.
     */
    public String toString() {
	return getClass().getName() + "[current=" + currentChoice + "]";
    }
}
