//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.applets.text;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Event;
import java.awt.TextArea;
import java.awt.TextField;

public class TextApplet extends Applet {
    private TextArea area = new TextArea( );
    private TextField field = new TextField( );

    public void init( ) {

        setLayout( new BorderLayout( ));

        add( "Center", area );
        add( "South", field );

        String initialString = getParameter( "text" );
        if( initialString != null )
            area.setText( initialString + "\n" );
        
        area.setEditable( false );
    }

    public boolean action( Event event, Object message ) {
        boolean used = false;

        if( event.target == field ) {
            area.appendText( field.getText( ));
            area.appendText( "\n" );

            field.setText( "" );

            used = true;
        }

        return used;
    }
}
