//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi.display;

import java.util.Hashtable;

import ibook.v11.idvi.font.DVICharacter;

class CharacterBlock extends Block {
    private static Hashtable    cache = new Hashtable( );

    static synchronized CharacterBlock getCharacterBlock( DVICharacter character ) {
        CharacterBlock result = ( CharacterBlock ) cache.get( character );
        
        if( result == null ) {
            result = new CharacterBlock( character );
            cache.put( character, result );
        }

        return result;
    }

    private DVICharacter character;

    private CharacterBlock( DVICharacter character ) {
        this.character = character;
    }

    private int                 lastScale;
    private ScaledCharacter     lastScaledCharacter;
    private ScaledColorScheme   lastColorScheme;
    private View                lastView;

    synchronized View getView( ScaledColorScheme colorScheme, int scale, ViewPanel panel ) {
        if( scale != lastScale || colorScheme != lastColorScheme ) {
            if( scale != lastScale ) {
                lastScale = scale;
                lastScaledCharacter = ScaledCharacter.getScaledCharacter( character, scale );
            }
            lastColorScheme = colorScheme;
            lastView = CharacterView.getCharacterView( lastScaledCharacter, colorScheme );
        }
        return lastView;
    }
}
