//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi.display;

import java.awt.Graphics;

class FilterView extends View {
    View            parent;
    int             indexInParent;

    Block           childBlock;
    View            child;

    FilterView( ScaledColorScheme colorScheme, int scale, ViewPanel panel, Block childBlock ) {
        this.childBlock = childBlock;

        child = childBlock.getView( colorScheme, scale, panel );
    }

    void setParent( View parent, int indexInParent ) {
        this.parent = parent;
        this.indexInParent = indexInParent;

        child.setParent( this, 0 );
    }

    int getFlags( ) {
        return child.getFlags( );
    }

    int getBounds( DVIRectangle bounds, int scale, int x, int y, Block block ) {
        return child.getBounds( bounds, scale, x, y, childBlock );
    }

    void showComponents( int componentXOffset, int componentYOffset ) {
        child.showComponents( componentXOffset, componentYOffset );
    }

    void hideComponents( ) {
        child.hideComponents( );
    }

    void paint( Graphics g, int color, DVIRectangle bounds, DVIRectangle clip, int yOffset ) {
        child.paint( g, color, bounds, clip, yOffset );
    }

    void mouseEnter( int x, int y ) {
        child.mouseEnter( x, y );
    }

    void mouseMove( int x, int y ) {
        child.mouseMove( x, y );
    }

    boolean mouseDown( int clickCount ) {
        return child.mouseDown( clickCount );
    }

    void mouseDrag( int x, int y ) {
        child.mouseDrag( x, y );
    }

    boolean mouseUp( int modifiers ) {
        return child.mouseUp( modifiers );
    }

    void mouseExit( ) {
        child.mouseExit( );
    }

    //  In the following methods we can assume that the parent is non-null,
    //  since we don't set ourselves as the parent of our child until we have a
    //  parent.

    void childAddedToBounds( DVIRectangle newBounds, int expansion ) {
        parent.childAddedToBounds( newBounds, expansion );
    }

    void childAddedToFlags( int newFlags ) {
        parent.childAddedToFlags( newFlags );
    }

    void childChangedExpansion( int childIndex, int expansionDelta, int yPosition ) {
        parent.childChangedExpansion( indexInParent, expansionDelta, yPosition );
    }

    void childBounds( DVIRectangle bounds, int childIndex ) {
        parent.childBounds( bounds, indexInParent );
    }

    int getBottomOfPreviousChild( int childIndex ) {
        return parent.getBottomOfPreviousChild( indexInParent );
    }

    void repaint( DVIRectangle repaintBounds, int childIndex, long delay ) {
        parent.repaint( repaintBounds, indexInParent, delay );
    }




    void printStructure( String indent ) {
        super.printStructure( indent );
        child.printStructure( indent + "  " );
    }
}
