//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi.dvi;

public interface DVIFormat {

    // Various magic values in a DVI file:

    final static int    kMagicDVI               = 247;          // first byte of a DVI file
    final static int    kMagicVersion           = 2;            // second byte of a DVI file
    final static int    kMagicFiller            = 223;          // last four (or more) bytes
    final static int    kMagicFirstBackpointer  = -1;           // to previous page from page 1


    // The lengths of some structures in a DVI file:

    final static int    kHeaderLength           = 14;           // includes first two bytes
    final static int    kPageHeaderLength       = 44;           // does not include kCommandBOP
    final static int    kFontHeaderLength       = 14;           // does not include FNTDEF or #
    final static int    kPostambleLength        = 28;           // does not include kCommandPOST


    // Information about the specials that we know about:

    final static String kSpecialHTML            = "html:";      // match is not case-sensitive
    final static String kSpecialPSFile          = "psfile=";    // match is not case-sensitive
    final static String kSpecialColor           = "color ";     // match is not case-sensitive


    // The html specials (the <a> and </a> are defined by the HyperTeX
    // group; the others are my own additions).
    //
    // All of these are non-case sensitive.  In fact, a rewrite should
    // make it possible to recognize each of these even if they have additional
    // options inside the angle brackets.  But not for this version!

    final static String kHTMLTagBeginAnchor     = "a";
    final static String kHTMLTagEndAnchor       = "/a";
    final static String kHTMLTagBeginApplet     = "applet";
    final static String kHTMLTagEndApplet       = "/applet";
    final static String kHTMLTagParam           = "param";

    final static String kHTMLParameterHREF      = "href";
    final static String kHTMLParameterTarget    = "target";
    final static String kHTMLParameterName      = "name";
    final static String kHTMLParameterValue     = "value";
    final static String kHTMLParameterCode      = "code";
    final static String kHTMLParameterWidth     = "width";
    final static String kHTMLParameterHeight    = "height";


    // Extra information for the PSFile special:

    final static double kPSFileDPI              = 72.0;

    final static String kPSFileName             = "psfile";
    final static String kPSFileTop              = "ury";
    final static String kPSFileLeft             = "llx";
    final static String kPSFileBottom           = "lly";
    final static String kPSFileRight            = "urx";
    final static String kPSFileForceWidth       = "rwi";
    final static String kPSFileForceHeight      = "rhi";


    // Extra information for the Color special:

    final static String kColorPush              = "push";
    final static String kColorPop               = "pop";
    final static String kColorRGB               = "rgb";
    final static String kColorCMYK              = "cmyk";


    // These strings should be command-line options just like scalePrefix and pagePrefix.

    final static String kPSFileWidthPrefix      = "w";
    final static String kPSFileHeightPrefix     = "h";


    // The actual tokens that make up a page in a DVI file:

    final static int    kLowCharacter           = 0;            // From 0 to 127 are SET1
    final static int    kHighCharacter          = 127;          // with argument 'command'.
    final static int    kCommandSET1            = 128;
    final static int    kCommandSETRULE         = 132;
    final static int    kCommandPUT1            = 133;
    final static int    kCommandPUTRULE         = 137;
    final static int    kCommandNOP             = 138;
    final static int    kCommandBOP             = 139;
    final static int    kCommandEOP             = 140;
    final static int    kCommandPUSH            = 141;
    final static int    kCommandPOP             = 142;
    final static int    kCommandRIGHT1          = 143;
    final static int    kCommandRIGHT2          = 144;
    final static int    kCommandRIGHT3          = 145;
    final static int    kCommandRIGHT4          = 146;
    final static int    kCommandW0              = 147;
    final static int    kCommandW1              = 148;
    final static int    kCommandW2              = 149;
    final static int    kCommandW3              = 150;
    final static int    kCommandW4              = 151;
    final static int    kCommandX0              = 152;
    final static int    kCommandX1              = 153;
    final static int    kCommandX2              = 154;
    final static int    kCommandX3              = 155;
    final static int    kCommandX4              = 156;
    final static int    kCommandDOWN1           = 157;
    final static int    kCommandDOWN2           = 158;
    final static int    kCommandDOWN3           = 159;
    final static int    kCommandDOWN4           = 160;
    final static int    kCommandY0              = 161;
    final static int    kCommandY1              = 162;
    final static int    kCommandY2              = 163;
    final static int    kCommandY3              = 164;
    final static int    kCommandY4              = 165;
    final static int    kCommandZ0              = 166;
    final static int    kCommandZ1              = 167;
    final static int    kCommandZ2              = 168;
    final static int    kCommandZ3              = 169;
    final static int    kCommandZ4              = 170;
    final static int    kLowFont                = 171;          // From 171 to 234 are FNT1
    final static int    kHighFont               = 234;          // with argument 'command - 171'.
    final static int    kCommandFNT1            = 235;
    final static int    kCommandFNT2            = 236;
    final static int    kCommandFNT3            = 237;
    final static int    kCommandFNT4            = 238;
    final static int    kCommandXXX1            = 239;
    final static int    kCommandXXX2            = 240;
    final static int    kCommandXXX3            = 241;
    final static int    kCommandXXX4            = 242;
    final static int    kCommandFNTDEF1         = 243;
    final static int    kCommandFNTDEF2         = 244;
    final static int    kCommandFNTDEF3         = 245;
    final static int    kCommandFNTDEF4         = 246;
    final static int    kCommandPRE             = 247;          // These three should not be seen
    final static int    kCommandPOST            = 248;          // in the body of a page.  PRE is
    final static int    kCommandPOSTPOST        = 249;          // the first byte of a DVI file.
}
