//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.parameter;

public class ParameterValueException extends ParameterException {
    private String parameterValue;

    public ParameterValueException( String parameterName, String parameterValue, String type ) {
        super( parameterName,
            "bad " + type + " \"" + parameterValue + "\" " +
            "in parameter \"" + parameterName + "\"" );
        
        this.parameterValue = parameterValue;
    }

    public ParameterValueException( String parameterName, String parameterValue ) {
        this( parameterName, parameterValue, "value" );
    }

    public String getParameterValue( ) {
        return parameterValue;
    }
}
