//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.colors;

import java.util.Hashtable;

public class Colors {
    //  This routine is used for "color push cmyk ## ## ## ##" specials,
    //  and also for creating the table of color values below.  The conversion
    //  should be improved (find a copy of Foley and van Dam).

    static int convert( double d ) {
        int result = ( int ) Math.floor( 256 * d );

        if( result < 0 ) result = 0;
        if( result > 255 ) result = 255;

        return result;
    }

    public static int getCMYKColor( double c, double m, double y, double k ) {
        int r = convert( 1 - k - c );
        int g = convert( 1 - k - m );
        int b = convert( 1 - k - y );

        return ( r << 16 ) | ( g << 8 ) | b;
    }

    public static int getRGBColor( double r, double g, double b ) {
        return ( convert( r ) << 16 ) | ( convert( g ) << 8 ) | convert( b );
    }

    public static boolean existsNamedColor( String name ) {
        return table.containsKey( name );
    }

    public static int getNamedColor( String name ) {
        Integer integer = ( Integer ) table.get( name );
        return integer != null ? integer.intValue( ) : 0;
    }

    final private static String padding = "000000";

    public static String toNetscapeString( int color ) {
        String hex = Integer.toString( color, 16 ).toUpperCase( );
        return "#" + padding.substring( hex.length( )) + hex;
    }

    public static String name[ ] = {
        "GreenYellow",      "Yellow",           "Goldenrod",        "Dandelion",        
        "Apricot",          "Peach",            "Melon",            "YellowOrange",     
        "Orange",           "BurntOrange",      "Bittersweet",      "RedOrange",        
        "Mahogany",         "Maroon",           "BrickRed",         "Red",      
        "OrangeRed",        "RubineRed",        "WildStrawberry",   "Salmon",       
        "CarnationPink",    "Magenta",          "VioletRed",        "Rhodamine",        
        "Mulberry",         "RedViolet",        "Fuchsia",          "Lavender",     
        "Thistle",          "Orchid",           "DarkOrchid",       "Purple",       
        "Plum",             "Violet",           "RoyalPurple",      "BlueViolet",       
        "Periwinkle",       "CadetBlue",        "CornflowerBlue",   "MidnightBlue",     
        "NavyBlue",         "RoyalBlue",        "Blue",             "Cerulean",     
        "Cyan",             "ProcessBlue",      "SkyBlue",          "Turquoise",        
        "TealBlue",         "Aquamarine",       "BlueGreen",        "Emerald",      
        "JungleGreen",      "SeaGreen",         "Green",            "ForestGreen",      
        "PineGreen",        "LimeGreen",        "YellowGreen",      "SpringGreen",      
        "OliveGreen",       "RawSienna",        "Sepia",            "Brown",        
        "Tan",              "Gray",             "Black",            "White"
    };

    public static int color[ ] = {
        0xD9FF4F, 0xFFFF00, 0xFFE628, 0xFFB528,
        0xFFAE7A, 0xFF804C, 0xFF8A80, 0xFF9400,
        0xFF6321, 0xFF7D00, 0xC20200, 0xFF3A21,
        0xA60000, 0xAE0000, 0xB80000, 0xFF0000,
        0xFF0080, 0xFF00DE, 0xFF0A9C, 0xFF789E,
        0xFF5EFF, 0xFF00FF, 0xFF30FF, 0xFF2EFF,
        0xA314FA, 0x9700A8, 0x7302EB, 0xFF85FF,
        0xE168FF, 0xAE5CFF, 0x9933CC, 0x8C23FF,
        0x8000FF, 0x351EFF, 0x4019FF, 0x190CF5,
        0x6E73FF, 0x616EC5, 0x59DEFF, 0x007091,
        0x0F75FF, 0x0080FF, 0x0000FF, 0x0FE3FF,
        0x00FFFF, 0x0AFFFF, 0x61FFE1, 0x26FFCC,
        0x1EFAA3, 0x2EFFB3, 0x26FFAB, 0x00FF80,
        0x02FF7A, 0x4FFF80, 0x00FF00, 0x00E100,
        0x00C028, 0x80FF00, 0x8FFF42, 0xBDFF3D,
        0x009900, 0x8C0000, 0x4C0000, 0x660000,
        0xDC9470, 0x808080, 0x000000, 0xFFFFFF,
    };

    public static Hashtable table;

    static {
        table = new Hashtable( name.length );

        for( int i = 0; i < name.length; ++ i )
            table.put( name[ i ], new Integer( color[ i ] ));
    }
}
