//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi;

import java.awt.*;
import java.awt.image.*;

import ibook.v11.parameter.ParameterProcessor;
import ibook.v11.parameter.ParameterException;
import ibook.v11.idvi.controls.Controls;
import ibook.v11.idvi.font.PKCharacter;
import ibook.v11.idvi.font.DVICharacter;
import ibook.v11.idvi.font.DVIFont;

final public class IDVI {
    private IDVI( ) {
    }

    // internal configuration constants:

    final public static int     kPriorityStartLoadingDocument   = 7;
    final public static int     kPriorityLoadDocument           = 3;
    final public static int     kPriorityLoadFont               = 1;

    final public static String  kIDVIURLPrefix          = "idvi:";
    final public static String  kToggleURLPrefix        = "toggle:";
    final public static String  kPageURLPrefix          = "page:";
    final public static String  kPageOffsetURLPrefix    = "pageoffset:";
    final public static String  kPageMinURL             = "pagemin";
    final public static String  kPageMaxURL             = "pagemax";
    final public static String  kScaleURLPrefix         = "scale:";
    final public static String  kScaleOffsetURLPrefix   = "scaleoffset:";
    final public static String  kScaleMinURL            = "scalemin";
    final public static String  kScaleMaxURL            = "scalemax";

    final public static long    kControlsHideDelay      = 2000;
    final public static long    kControlsMessageDelay   = 5000;
    final public static String  kControlsTitle          = "DVI Controls";
    final public static String  kVersionString          = "DVI Viewer 1.1 by Garth A. Dickie";
    final public static String  kApplicationVersionString= "IDVI version 1.1 by Garth A. Dickie";
    final public static String  kHelpURLString          = "http://www.geom.umn.edu/java/idvi/viewer/v11/index.html";
    final public static String  kZoomMessage1           = "Click on document to show";
    final public static String  kZoomMessage2           = "magnified view here";

    public final static int     kScaleMin               = 1;            // actual minimum and maximum
    public final static int     kScaleMax               = 15;           // values




    // default values for parameters:

    final public static String  kDefaultCode            = "ibook.release.DVIOnePageApplet";
    final public static int     kDefaultDPI             = 300;
    final public static int     kDefaultScaleMin        = 1;
    final public static int     kDefaultScaleMax        = 5;
    final public static int     kDefaultScaleDefault    = 4;
    final public static int     kDefaultPageMin         = 1;
    final public static String  kDefaultPrefix          = "";
    final public static String  kDefaultScalePrefix     = "scale";
    final public static String  kDefaultPagePrefix      = "page";
    final public static String  kDefaultIndex           = "index.html";
    final public static boolean kDefaultCentered        = true;         // used only in splitter

    final public static int     kDefaultBackgroundColor     = 0xFFFFFF;
    final public static int     kDefaultForegroundColor     = 0x000000;
    final public static int     kDefaultSelectionColor      = 0xC0FFFF;
    final public static int     kDefaultLinkColor           = 0x0000EE;
    final public static int     kDefaultSelectedLinkColor   = 0xFF0000;




    public static boolean       debugStructure          = false;
    public static boolean       debugLayout             = false;
    public static boolean       debugFontLog            = false;
    public static boolean       debugSpecials           = false;
    public static int           debugTokenDelay         = 0;
    public static boolean       debugTokenLog           = false;
    public static boolean       debugDisplay            = false;

    public static void setDebugParameters( ParameterProcessor parameter )
            throws ParameterException {

        debugStructure   = parameter.getBoolean( "debugStructure"  , debugStructure   );
        debugLayout      = parameter.getBoolean( "debugLayout"     , debugLayout      );
        debugFontLog     = parameter.getBoolean( "debugFontLog"    , debugFontLog     );
        debugSpecials    = parameter.getBoolean( "debugSpecials"   , debugSpecials    );
        debugTokenDelay  = parameter.getInteger( "debugTokenDelay" , debugTokenDelay  );
        debugTokenLog    = parameter.getBoolean( "debugTokenLog"   , debugTokenLog    );
        debugDisplay     = parameter.getBoolean( "debugDisplay"    , debugDisplay     );
    }

    public static void printDebugInformation( ) {
    }
}
