//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi.display;

abstract class ActionBlock extends Block {
    final private static int    kViewInitialLength = 2;
    final private static int    kViewIncrementLength = 2;

    private int                 viewCount;
    private ActionView[ ]       view;
    private ActionBlockGroup    group;
    private Block               child;

    private boolean             selected;
    private boolean             childDoneLoading;

    ActionBlock( ActionBlockGroup group ) {
        this.group = group;

        group.addActionBlock( this );
        selected = group.getSelected( );
    }

    void setChild( Block child ) {
        this.child = child;
    }

    //  setSelected is only called by the ActionBlockGroup which
    //  contains this ActionBlock.

    void setSelected( boolean selected ) {
        this.selected = selected;

        for( int i = 0; i < viewCount; ++ i )
            view[ i ].setSelected( selected );
    }

    void childDoneLoading( ) {
        this.childDoneLoading = true;

        for( int i = 0; i < viewCount; ++ i )
            view[ i ].childDoneLoading( );
    }

    View getView( ScaledColorScheme colorScheme, int scale, ViewPanel panel ) {
        ActionView result = getActionView( colorScheme, scale, panel, group, child, selected, childDoneLoading );

        addView( result );

        return result;
    }

    abstract ActionView getActionView(
            ScaledColorScheme colorScheme, int scale, ViewPanel panel,
            ActionBlockGroup group, Block child, boolean selected, boolean childDoneLoading );




    private synchronized void addView( ActionView newView ) {
        if( view == null )
            view = new ActionView[ kViewInitialLength ];
        else if( viewCount == view.length )
            setViewLength( view.length + kViewIncrementLength );

        view[ viewCount ++ ] = newView;
    }

    private void setViewLength( int length ) {
        View[ ] oldView = view;
        view = new ActionView[ length ];
        System.arraycopy( oldView, 0, view, 0, Math.min( oldView.length, length ));
    }
}
