//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi.display;

import java.util.Hashtable;

class RuleBlock extends Block {
    private static Hashtable    cache = new Hashtable( );
    private static RuleBlock    key = new RuleBlock( );

    static synchronized RuleBlock getRuleBlock( int width, int height ) {
        key.width = width;
        key.height = height;

        RuleBlock result = ( RuleBlock ) cache.get( key );
        
        if( result == null ) {
            result = key;
            cache.put( key, result );
            key = new RuleBlock( );
        }

        return result;
    }




    private int     width;
    private int     height;

    private RuleBlock( ) {
    }

    void getBounds( DVIRectangle bounds, int scale, int x, int y ) {
        int scaledX = x / scale;
        int scaledY = y / scale;

        bounds.set(
            scaledY - ( height + scale - 1 ) / scale,
            scaledX,
            scaledY,
            scaledX + ( width + scale - 1 ) / scale );
    }

    View getView( ScaledColorScheme colorScheme, int scale, ViewPanel panel ) {
        return RuleView.getRuleView( colorScheme, width, height, scale );
    }




    public int hashCode( ) {
        return width ^ ( height << 16 );
    }

    public boolean equals( Object object ) {
        return object instanceof RuleBlock && equals(( RuleBlock ) object );
    }

    public boolean equals( RuleBlock key ) {
        return key.width == width && key.height == height;
    }
}
