//  IDVI 1.1 source copyright 1996-97 Garth A. Dickie
//
//  This source is free for non-commercial use.  No warranty, etc.
//  Please acknowledge reuse by including the line:
//
//  "Based in part on IDVI 1.1 source copyright 1996-97 Garth A. Dickie"
//
//  in your documentation and source code.  For commercial use or
//  distribution, please contact the author.  Please also send
//  questions, comments, bug reports, or fixes.
//
//  A description of the class hierarchy and some design notes are
//  available at <http://www.geom.umn.edu/java/idvi/designnotes/>.
//
//  Best Regards,
//  Garth A. Dickie
//  dickie@elastic.avid.com

package ibook.v11.idvi.split;

import ibook.v11.idvi.IDVI;

interface HTMLParameters {
    final static String[ ] parameters = {

        //  Templates for the text between begin and end tags:

        "template",

            "<html><head><title>$titletemplate</title></head>\n" +
            "<body bgcolor=$backgroundColor text=$foregroundColor link=$linkColor alink=$selectedLinkColor>\n" +
            "<p align=center>\n" +
            "$applet\n" +
            "</p></body></html>\n",
        
        "applet",
            "<applet$codeBaseParam$archiveParam code=$code width=$width height=$height>\n" +
            "$dpiParamTag" +
            "$fontBaseParamTag" +
            "$pageMinParamTag" +
            "$pageMaxParamTag" +
            "$pageDefaultParamTag" +
            "$scaleMinParamTag" +
            "$scaleMaxParamTag" +
            "$scaleDefaultParamTag" +
            "$prefixParamTag" +
            "$pagePrefixParamTag" +
            "$scalePrefixParamTag" +
            "$indexParamTag" +
            "$leftMarginDeltaParamTag" +
            "$topMarginDeltaParamTag" +
            "$backgroundColorParamTag" +
            "$foregroundColorParamTag" +
            "$selectionColorParamTag" +
            "$linkColorParamTag" +
            "$selectedLinkColorParamTag" +
            "$noAppletText" +
            "</applet>",

        //  These may be overridden directly from the command line:

        "code",             IDVI.kDefaultCode,
        "title",            "${}",              //  name of the source dvi file.
        "titleTemplate",    "$title - $page",
        "noAppletText",     "Sorry, your browser does not support Java applets",

        //  codeBaseParam is overridden by the splitter if no codeBase is given,
        //  and archiveParam is overridden if no archive name is given.  This is
        //  what makes idvi.local work.

        "codeBaseParam",    " codeBase=$codeBase",
        "archiveParam",     " archive=$archive",

        //  The <param> tags themselves.  Many are not needed if they would contain
        //  a default value; in this case the splitter application overrides this
        //  definition with an empty definition.

        "dpiParamTag",          "<param name=dpi value=$dpi>\n",
        "fontBaseParamTag",     "<param name=fontBase value=\"$fontBase\">\n",
        "pageMinParamTag",      "<param name=pageMin value=$pageMin>\n",
        "pageMaxParamTag",      "<param name=pageMax value=$pageMax>\n",
        "pageDefaultParamTag",  "<param name=pageDefault value=$pageDefault>\n",
        "scaleMinParamTag",     "<param name=scaleMin value=$scaleMin>\n",
        "scaleMaxParamTag",     "<param name=scaleMax value=$scaleMax>\n",
        "scaleDefaultParamTag", "<param name=scaleDefault value=$scaleDefault>\n",
        "prefixParamTag",       "<param name=prefix value=$prefix>\n",
        "pagePrefixParamTag",   "<param name=pagePrefix value=$pagePrefix>\n",
        "scalePrefixParamTag",  "<param name=scalePrefix value=$scalePrefix>\n",
        "indexParamTag",        "<param name=index value=$index>\n",

        "leftMarginDeltaParamTag",  "<param name=leftMarginDelta value=$leftMarginDelta>\n",
        "topMarginDeltaParamTag",   "<param name=topMarginDelta value=$topMarginDelta>\n",

        "backgroundColorParamTag",      "<param name=backgroundColor value=$backgroundColor>\n",
        "foregroundColorParamTag",      "<param name=foregroundColor value=$foregroundColor>\n",
        "selectionColorParamTag",       "<param name=selectionColor value=$selectionColor>\n",
        "linkColorParamTag",            "<param name=linkColor value=$linkColor>\n",
        "selectedLinkColorParamTag",    "<param name=selectedLinkColor value=$selectedLinkColor>\n"
    };

    //  Parameters that are gauranteed to have been set by the Splitter, which are static
    //  (don't change with the page or scale):
    //
    //      "dpi"
    //      "fontBase"
    //      "pageMin"
    //      "pageMax"
    //      "pageDefault
    //      "scaleMin"
    //      "scaleMax"
    //      "scaleDefault"
    //      "prefix"
    //      "pagePrefix"
    //      "scalePrefix"
    //      "index"
    //      "centered"
    //
    //  Parameters that are gauranteed to have been set by the Splitter, which are not static:
    //  
    //      "page"
    //      "scale"
    //      "width"
    //      "height"
    //      "leftMarginDelta"
    //      "topMarginDelta"
    //      "pageMinURL"
    //      "pageMaxURL"
    //      "pageMinusURL"
    //      "pagePlusURL"
    //      "scaleMinURL"
    //      "scaleMaxURL"
    //      "scaleMinusURL"
    //      "scalePlusURL"
}
